﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Threading;
using System.Diagnostics;
using System.Runtime.InteropServices;
using System.Xml;

namespace AppWindowForcer
{
    public partial class frmWinSnhr : Form
    {
        public frmWinSnhr()
        {
            InitializeComponent();
        }

        [DllImport("user32.dll")]
        public static extern IntPtr SetParent(IntPtr hWndChild, IntPtr hWndNewParent);

        [DllImport("user32.dll")]
        public static extern int SetWindowLong(IntPtr hWnd, int nIndex, IntPtr dwNewLong);

        public const int GWL_STYLE = -16;
        public const uint WS_VISIBLE = 0x10000000;
        public const uint WS_SYSMENU = 0x80000;
        public const uint WS_BORDER = 0x800000;

        [DllImport("user32.dll")]
        public static extern bool SetWindowPlacement(IntPtr hWnd, [In] ref WINDOWPLACEMENT lpwndpl);

        public struct WINDOWPLACEMENT
        {
            public int length;
            public int flags;
            public int showCmd;
            public POINTAPI ptMinPosition;
            public POINTAPI ptMaxPosition;
            public RECT rcNormalPosition;
        }

        public struct POINTAPI
        {
            public int x;
            public int y;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct RECT
        {
            public int Left;
            public int Top;
            public int Right;
            public int Bottom;
        }

        [DllImport("user32.dll")]
        [return: MarshalAs(UnmanagedType.Bool)]
        public static extern bool GetWindowPlacement(IntPtr hWnd, ref WINDOWPLACEMENT lpwndpl);

        [DllImport("user32.dll")]
        public static extern bool MoveWindow(IntPtr hWnd, int X, int Y, int nWidth, int nHeight, bool bRepaint);

        [DllImport("user32.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern int GetWindowText(IntPtr hWnd, StringBuilder lpString, int nMaxCount);

        [DllImport("kernel32.dll", SetLastError = true)]
        private static extern IntPtr CreateToolhelp32Snapshot(uint dwFlags, uint th32ProcessID);

        [DllImport("kernel32.dll")]
        private static extern bool Process32First(IntPtr hSnapshot, ref PROCESSENTRY32 lppe);

        [DllImport("kernel32.dll")]
        private static extern bool Process32Next(IntPtr hSnapshot, ref PROCESSENTRY32 lppe);

        [StructLayout(LayoutKind.Sequential)]
        private struct PROCESSENTRY32
        {
            public uint dwSize;
            public uint cntUsage;
            public uint th32ProcessID;
            public IntPtr th32DefaultHeapID;
            public uint th32ModuleID;
            public uint cntThreads;
            public uint th32ParentProcessID;
            public int pcPriClassBase;
            public uint dwFlags;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 260)]
            public string szExeFile;
        }

        static Process process;
        Process OrigProcess;
        //static WINDOWPLACEMENT wndplc;
        static IntPtr hndle;
        static int width = 400;
        static int height = 300;
        static Boolean shifting = false;
        Process[] processes;
        bool useProcessName = false;

        private void frmWinSnhr_Load(object sender, EventArgs e)
        {

        }

        private void frmWinSnhr_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing && (OrigProcess != null || process != null))
            {
                DialogResult result = MessageBox.Show("Are you sure you want to exit this application and kill/stop any snatched programs too?", "Exit WinSnatcher Application", MessageBoxButtons.YesNoCancel);
                if (result == DialogResult.Cancel)
                {
                    e.Cancel = true;
                    return;
                }
                else if (result == DialogResult.No)
                {
                    e.Cancel = true;
                    if (chkRestartOnNoKill.Checked)
                    {
                        //"C:\\1 Everything\\Programming\\Visual Studio 2013 Projects\\AppWindowForcer\\AppWindowForcer\\bin\\Release\\WinSnatcher.exe"
                        Process.Start(Process.GetCurrentProcess().Modules[0].FileName);
                    }
                    Process.GetCurrentProcess().Kill();
                    return;
                }
                else if (result == DialogResult.Yes)
                {
                    if (OrigProcess != null)
                    {
                        killChildProcesses(OrigProcess.Id);
                        if (!OrigProcess.HasExited)
                            OrigProcess.Kill();
                    }
                    if (process != null)
                    {
                        killChildProcesses(process.Id);
                        if (!process.HasExited)
                            process.Kill();
                    }
                }
            }
        }

        private void Snatch()
        {
            pnlMain.Enabled = false;
            pnlMain.Visible = false;
            pnlSnatch1.Enabled = false;
            pnlSnatch1.Visible = false;
            pnlSnatch2.Enabled = false;
            pnlSnatch2.Visible = false;
            hndle = this.Handle;
            if (!process.HasExited && process != null && process.Responding)
            {
                this.MinimumSize = new Size(140, 60);
                this.MaximumSize = new Size(48000, 48000);
                SetParent(process.MainWindowHandle, hndle);
                SetWindowLong(process.MainWindowHandle, GWL_STYLE, (IntPtr)WS_VISIBLE);
                this.Text = process.MainWindowTitle;
                ResizeWindow();
            }
            else
            {
                System.Threading.Thread.Sleep(1000);
                if (process.HasExited)
                {
                    if (MessageBox.Show("Has the Program's Window Re-appeared?\nGrab or cancel.", "Grab Window Yet?", MessageBoxButtons.OKCancel) == DialogResult.OK)
                    {
                        Process[] newprocesses = Array.FindAll(getChildProcesses(process.Id), hasTitle).ToArray();
                        OrigProcess = process;
                        process = getChildProcesses(process.Id).First();
                        Snatch();
                        return;
                    }
                }
                MessageBox.Show("Failed to Open Process");
                pnlMain.Enabled = true;
                pnlMain.Visible = true;
            }
        }

        private void tmrRefresh_Tick(object sender, EventArgs e)
        {
            if (process != null && !process.HasExited && process.Responding)
            {
                StringBuilder title = new StringBuilder(256);
                GetWindowText(process.MainWindowHandle, title, 256);
                this.Text = title.ToString();
            }
        }

        private void ResizeWindow()
        {
            System.Media.SystemSounds.Beep.Play();
            width = this.Size.Width;
            height = this.Size.Height;
            MoveWindow(process.MainWindowHandle, 0, 0, width - 16, height - 38, true);
            //GetWindowPlacement(process[0].MainWindowHandle, ref wndplc);
            //SetWindowPlacement(hndle, ref wndplc);
            //GetWindowPlacement(hndle, ref wndplc);
            //SetWindowPlacement(process.MainWindowHandle, ref wndplc);
        }

        private void frmWinSnhr_Resize(object sender, EventArgs e)
        {
            if (shifting)
            {
                if (WindowState == FormWindowState.Maximized || WindowState == FormWindowState.Normal)
                {
                    ResizeWindow();
                }
            }
        }

        private void frmAWF_ResizeEnd(object sender, EventArgs e)
        {
            if (shifting)
            {
                ResizeWindow();
            }
        }

        private void frmAWF_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.ShiftKey)
            {
                shifting = true;
            }
        }

        private void frmAWF_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.ShiftKey)
            {
                shifting = false;
            }
        }

        public static Process[] getChildProcesses(int parentProcessID)
        {
            var ret = new List<Process>();
            uint TH32CS_SNAPPROCESS = 2;

            IntPtr hSnapshot = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
            if (hSnapshot == IntPtr.Zero)
            {
                return ret.ToArray();
            }
            PROCESSENTRY32 procInfo = new PROCESSENTRY32();
            procInfo.dwSize = (uint)Marshal.SizeOf(typeof(PROCESSENTRY32));
            if (Process32First(hSnapshot, ref procInfo) == false)
            {
                return ret.ToArray();
            }
            do
            {
                if ((int)procInfo.th32ParentProcessID == parentProcessID)
                {
                    ret.Add(Process.GetProcessById((int)procInfo.th32ProcessID));
                }
            }
            while (Process32Next(hSnapshot, ref procInfo));

            return ret.ToArray();
        }

        public static void killChildProcesses(int parentProcessID)
        {
            foreach (var p in getChildProcesses(parentProcessID))
            {
                if (!p.HasExited)
                    p.Kill();
            }
        }

        private void getprograms()
        {
            processes = Process.GetProcesses();
            if (!useProcessName)
            {
                processes = Array.FindAll(processes, hasTitle).ToArray();
            }

            if (chkPIDFirst.Checked)
            {
                Array.Sort(processes, delegate(Process object1, Process object2)
                {
                    return object1.Id.CompareTo(object1.Id);
                });
            }
            else
            {
                Array.Sort(processes, delegate(Process object1, Process object2)
                {
                    return object1.ProcessName.CompareTo(object1.ProcessName);
                });
            }
            lstProcess.Items.Clear();

            if (useProcessName)
            {
                for (int i = 0; i < processes.Length; i++)
                {
                    if (chkPIDFirst.Checked)
                        lstProcess.Items.Add(processes[i].Id + " [" + processes[i].ProcessName + "]");
                    else
                        lstProcess.Items.Add(processes[i].ProcessName + " [" + processes[i].Id + "]");
                }
            }
            else
            {
                for (int i = 0; i < processes.Length; i++)
                {
                    if (chkPIDFirst.Checked)
                        lstProcess.Items.Add(processes[i].Id + " [" + processes[i].ProcessName + "]" + " - " + processes[i].MainWindowTitle);
                    else
                        lstProcess.Items.Add(processes[i].ProcessName + " [" + processes[i].Id + "]" + " - " + processes[i].MainWindowTitle);
                }
            }
        }

        static bool hasTitle(Process p)
        {
            if (p.MainWindowTitle.Length > 1)
                return true;
            else
                return false;
        }

        private void btnSnatchNameID_Click(object sender, EventArgs e)
        {
            pnlMain.Enabled = false;
            useProcessName = true;
            getprograms();
            pnlMain.Visible = false;
            pnlSnatch2.Enabled = false;
            pnlSnatch2.Visible = false;
            pnlSnatch1.Enabled = true;
            pnlSnatch1.Visible = true;
        }

        private void btnSnatchWindow_Click(object sender, EventArgs e)
        {
            pnlMain.Enabled = false;
            useProcessName = false;
            getprograms();
            pnlMain.Visible = false;
            pnlSnatch2.Enabled = false;
            pnlSnatch2.Visible = false;
            pnlSnatch1.Enabled = true;
            pnlSnatch1.Visible = true;
        }

        private void chkPIDFirst_CheckedChanged(object sender, EventArgs e)
        {
            getprograms();
        }

        private void lstProcess_DoubleClick(object sender, EventArgs e)
        {
            if (lstProcess.SelectedIndex >= 0)
            {
                process = processes[lstProcess.SelectedIndex];
                Snatch();
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (lstProcess.SelectedIndex >= 0)
            {
                process = processes[lstProcess.SelectedIndex];
                Snatch();
            }
        }

        private void btnSnatchViaName_Click(object sender, EventArgs e)
        {
            pnlMain.Enabled = false;
            processes = Process.GetProcesses();
            Array.Sort(processes, delegate(Process object1, Process object2)
            {
                return object1.ProcessName.CompareTo(object1.ProcessName);
            });
            txtSnatchName.AutoCompleteCustomSource.Clear();
            for (int i = 0; i < processes.Length; i++)
            {
                txtSnatchName.AutoCompleteCustomSource.Add(processes[i].ProcessName);
            }
            pnlMain.Visible = false;
            pnlSnatch1.Enabled = false;
            pnlSnatch1.Visible = false;
            pnlSnatch2.Enabled = true;
            pnlSnatch2.Visible = true;
        }

        private void btnSnatchFile_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();
            openFileDialog1.Filter = "Application|*.exe|All Files|*.*";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.Multiselect = false;
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                ProcessStartInfo startInfo = new ProcessStartInfo();
                startInfo.FileName = openFileDialog1.FileName;
                process = Process.Start(startInfo);
                if (MessageBox.Show("Has the Program's Window Appeared?\nGrab or cancel.", "Grab Window Yet?", MessageBoxButtons.OKCancel) == DialogResult.OK)
                    Snatch();
                else
                    return;
            }
        }

        private void btnSnatchNameOK_Click(object sender, EventArgs e)
        {
            pnlSnatch2.Enabled = false;
            if (Process.GetProcessesByName(txtSnatchName.Text).Length > 0)
                process = Process.GetProcessesByName(txtSnatchName.Text).First();
            else
                process = null;
            pnlSnatch2.Visible = false;
            Snatch();
        }

        private void btnSnatchNameCancel_Click(object sender, EventArgs e)
        {
            pnlSnatch1.Enabled = false;
            pnlSnatch1.Visible = false;
            pnlSnatch2.Enabled = false;
            pnlSnatch2.Visible = false;
            pnlMain.Enabled = true;
            pnlMain.Visible = true;
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            pnlSnatch1.Enabled = false;
            pnlSnatch1.Visible = false;
            pnlSnatch2.Enabled = false;
            pnlSnatch2.Visible = false;
            pnlMain.Enabled = true;
            pnlMain.Visible = true;
        }

        private void btnSettings_Click(object sender, EventArgs e)
        {
            pnlSnatch1.Enabled = false;
            pnlSnatch1.Visible = false;
            pnlSnatch2.Enabled = false;
            pnlSnatch2.Visible = false;
            pnlMain.Enabled = false;
            pnlMain.Visible = false;
            pnlSettings.Enabled = true;
            pnlSettings.Visible = true;
            lblVersion.Text = this.ProductVersion;
        }

        private void btnSettingsback_Click(object sender, EventArgs e)
        {
            pnlSnatch1.Enabled = false;
            pnlSnatch1.Visible = false;
            pnlSnatch2.Enabled = false;
            pnlSnatch2.Visible = false;
            pnlSettings.Enabled = false;
            pnlSettings.Visible = false;


            pnlMain.Enabled = true;
            pnlMain.Visible = true;
        }

        private void xmlTests()
        {
            //http://www.dotnetperls.com/xmlreader
            // Create an XML reader for this file.
            using (XmlReader reader = XmlReader.Create("perls.xml"))
            {
                while (reader.Read())
                {
                    // Only detect start elements.
                    if (reader.IsStartElement())
                    {
                        // Get element name and switch on it.
                        switch (reader.Name)
                        {
                            case "perls":
                                // Detect this element.
                                Console.WriteLine("Start <perls> element.");
                                break;
                            case "article":
                                // Detect this article element.
                                Console.WriteLine("Start <article> element.");
                                // Search for the attribute name on this current node.
                                string attribute = reader["name"];
                                if (attribute != null)
                                {
                                    Console.WriteLine("  Has attribute name: " + attribute);
                                }
                                // Next read will contain text.
                                if (reader.Read())
                                {
                                    Console.WriteLine("  Text node: " + reader.Value.Trim());
                                }
                                break;
                        }
                    }
                }
            }
        }
    }
}